package it.eng.eremita.graphql.types;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import graphql.servlet.GraphQLContext;
import io.leangen.graphql.annotations.GraphQLArgument;
import io.leangen.graphql.annotations.GraphQLMutation;
import io.leangen.graphql.annotations.GraphQLQuery;
import it.eng.eremita.graphql.annotations.Metadata;
import it.eng.eremita.graphql.types.other.Filter;
import it.eng.eremita.graphql.types.other.OrderBy;
import it.eng.eremita.graphql.types.other.Pagination;
import it.eng.eremita.jpa.entity.CondizioniMeteo;
import it.eng.eremita.jpa.entity.Config;
import it.eng.eremita.jpa.entity.Documento;
import it.eng.eremita.jpa.entity.HabitatSpecie;
import it.eng.eremita.jpa.entity.Intervento;
import it.eng.eremita.jpa.entity.Limpidezza;
import it.eng.eremita.jpa.entity.Marcatura;
import it.eng.eremita.jpa.entity.Metadato;
import it.eng.eremita.jpa.entity.MetadatoHabitat;
import it.eng.eremita.jpa.entity.MonitoraggioHabitat;
import it.eng.eremita.jpa.entity.MonitoraggioSpecie;
import it.eng.eremita.jpa.entity.Permesso;
import it.eng.eremita.jpa.entity.Ruolo;
import it.eng.eremita.jpa.entity.Segnalazione;
import it.eng.eremita.jpa.entity.SegnalazioneAltreSpecie;
import it.eng.eremita.jpa.entity.SitoNatura2000;
import it.eng.eremita.jpa.entity.Specie;
import it.eng.eremita.jpa.entity.SpecieProgettoEremita;
import it.eng.eremita.jpa.entity.StadioSviluppo;
import it.eng.eremita.jpa.entity.TipoMarcatura;
import it.eng.eremita.jpa.entity.TipoReperto;
import it.eng.eremita.jpa.entity.TipologiaMonitoraggio;
import it.eng.eremita.jpa.entity.Utente;
import it.eng.eremita.jpa.entity.ValoreMetadato;
import it.eng.eremita.jpa.manager.Accessor;
import it.eng.eremita.jpa.manager.EremitaManager;
import it.eng.eremita.jpa.util.ObjectAuthorizerFactory;
import it.eng.eremita.jpa.util.QueryBuilder;

public class Query {
	
	private SessionProvider sessionProvider;
	
	
	private static final Map<String,String> tipiQueryDocumento = new HashMap<String,String>();
	private static final Map<String,String> tipiQueryMonitoraggioSpecie = new HashMap<String,String>();
	private static final Map<String,String> tipiQuerySpecie = new HashMap<String,String>();
	private static final Map<String,String> tipiQuerySitiNatura2000 = new HashMap<String,String>();
	private static final Map<String,String> tipiQueryUtente = new HashMap<String,String>();

	private static final String queryDocumentiSmartFilter =
			//"SELECT * from EREMITA_DOCUMENTO where in_elenco='S' and (upper(nome_file) like ? or upper(descrizione) like ?)";
			"SELECT * from EREMITA_DOCUMENTO where (upper(nome_file) like ? or upper(descrizione) like ?)";
	
	private static final String queryCountDocumentiSmartFilter =
			"SELECT count(*) from EREMITA_DOCUMENTO where (upper(nome_file) like ? or upper(descrizione) like ?)";
	
	private static final String queryNatura2000SmartFilter = 
			"SELECT * from EREMITA_SITI_N2000 where upper(id) like ? or upper(nome) like ? order by id";
	
	private static final String querySpecieSmartFilter = 
			"SELECT *  from N2000_TAXON_TASSONOMIA where upper(denominazione_taxon) like ? or upper(nome_italiano) like ? order by denominazione_taxon";

	
	private static final String queryUtenteSmartFilter =
			"select ms.* from main_utente ms where (upper(ms.id) like ? or upper(nome) like ? or upper(cognome) like ? or upper(email) like ?) ";
	
	private static final String queryCountUtenteSmartFilter =
			"select count(*) from main_utente ms where (upper(ms.id) like ? or upper(nome) like ? or upper(cognome) like ? or upper(email) like ?) ";
	
	
	private static final String queryMonitoraggioSpecieSmartFilter = 
			"select ms.* from eremita_monitoraggio_specie ms left join eremita_siti_n2000 s on ms.id_sito = s.id left join n2000_taxon_tassonomia t on ms.id_specie=t.id where ("+
			"upper(ms.id_scheda) like ? or upper(ms.rilevatori) like ? or upper(ms.localita) like ? or upper(ms.transetto) like ? or upper(ms.id_tipologia_monitoraggio) like ? "+
			"or upper(ms.ente) like ? or upper(s.nome) like ? or upper(t.denominazione_completa_taxon) like ?)";
	
	private static final String queryCountMonitoraggioSpecieSmartFilter = 
			"select count(*) from eremita_monitoraggio_specie ms left join eremita_siti_n2000 s on ms.id_sito = s.id left join n2000_taxon_tassonomia t on ms.id_specie=t.id where ("+
			"upper(ms.id_scheda) like ? or upper(ms.rilevatori) like ? or upper(ms.localita) like ? or upper(ms.transetto) like ? or upper(ms.id_tipologia_monitoraggio) like ? "+
			"or upper(ms.ente) like ? or upper(s.nome) like ? or upper(t.denominazione_completa_taxon) like ?)";
	
	private static final String queryInterventoSmartFilter = 
			"select ms.* from eremita_intervento ms left join eremita_siti_n2000 s on ms.id_sito = s.id left join n2000_taxon_tassonomia t on ms.id_specie=t.id where ("+
			"upper(ms.id_scheda) like ? or upper(ms.rilevatori) like ? or upper(ms.transetto) like ? "+
			"or upper(ms.ente) like ? or upper(s.nome) like ? or upper(t.denominazione_completa_taxon) like ?)";
	
	private static final String queryCountInterventoSmartFilter = 
			"select count(*) from eremita_intervento ms left join eremita_siti_n2000 s on ms.id_sito = s.id left join n2000_taxon_tassonomia t on ms.id_specie=t.id where ("+
			"upper(ms.id_scheda) like ? or upper(ms.rilevatori) like ? or upper(ms.transetto) like ? "+
			"or upper(ms.ente) like ? or upper(s.nome) like ? or upper(t.denominazione_completa_taxon) like ?)";
	
	
	private static final String queryMonitoraggioHabitatSmartFilter = 
			"select ms.* from eremita_monitoraggio_habitat ms left join eremita_siti_n2000 s on ms.id_sito = s.id left join n2000_taxon_tassonomia t on ms.id_specie=t.id where ("+
			"upper(ms.id_scheda) like ? or upper(ms.rilevatori) like ? or upper(ms.localita) like ? or upper(ms.transetto) like ? or upper(ms.id_tipologia_monitoraggio) like ? "+
			"or upper(ms.ente) like ? or upper(s.nome) like ? or upper(t.denominazione_completa_taxon) like ?)";
	
	private static final String queryCountMonitoraggioHabitatSmartFilter = 
			"select count(*) from eremita_monitoraggio_habitat ms left join eremita_siti_n2000 s on ms.id_sito = s.id left join n2000_taxon_tassonomia t on ms.id_specie=t.id where ("+
			"upper(ms.id_scheda) like ? or upper(ms.rilevatori) like ? or upper(ms.localita) like ? or upper(ms.transetto) like ? or upper(ms.id_tipologia_monitoraggio) like ? "+
			"or upper(ms.ente) like ? or upper(s.nome) like ? or upper(t.denominazione_completa_taxon) like ?)";
	
	
	private static final String queryMetadatiHabitatPerSpecie =
			"select * from main_metadato where id in (select distinct h.id_metadato from eremita_metadato_habitat h join eremita_monitoraggio_habitat m on h.id_habitat=m.id where m.id_specie=?)";
	
	static {
		
		tipiQueryDocumento.put("id", "long");
		tipiQueryDocumento.put("doc_uuid", "string");
		tipiQueryDocumento.put("nome_file", "string");
		tipiQueryDocumento.put("id_interno", "string");
		tipiQueryDocumento.put("formato", "string");
		tipiQueryDocumento.put("entita", "string");
		tipiQueryDocumento.put("id_entita", "string");
		tipiQueryDocumento.put("in_elenco", "string");
		
		tipiQueryMonitoraggioSpecie.put("id", "long");
		tipiQueryMonitoraggioSpecie.put("id_specie", "long");
		tipiQueryMonitoraggioSpecie.put("id_sito", "long");
		tipiQueryMonitoraggioSpecie.put("id_scheda", "string");
		tipiQueryMonitoraggioSpecie.put("rilevatori", "string");
		tipiQueryMonitoraggioSpecie.put("comune", "string");
		tipiQueryMonitoraggioSpecie.put("provincia", "string");
		tipiQueryMonitoraggioSpecie.put("localita", "string");
		
		tipiQuerySitiNatura2000.put("id", "string");
		tipiQuerySitiNatura2000.put("tipo", "string");
		tipiQuerySitiNatura2000.put("nome", "string");
		
		tipiQuerySpecie.put("id", "long");
		tipiQuerySpecie.put("autore", "string");
		tipiQuerySpecie.put("classe", "string");
		tipiQuerySpecie.put("denominazione_completa_taxon", "string");
		tipiQuerySpecie.put("denominazione_taxon", "string");
		tipiQuerySpecie.put("denominazione_taxon_buono", "string");
		tipiQuerySpecie.put("famiglia", "string");
		tipiQuerySpecie.put("genere", "string");
		tipiQuerySpecie.put("nome_italiano", "string");
		tipiQuerySpecie.put("non_taxon", "string");
		tipiQuerySpecie.put("note", "string");
		tipiQuerySpecie.put("ordine", "string");
		tipiQuerySpecie.put("sinonimo_accettato", "string");
		tipiQuerySpecie.put("sottospecie", "string");
		tipiQuerySpecie.put("specie", "string");
		tipiQuerySpecie.put("taxgroup", "string");
		tipiQuerySpecie.put("taxon_buono", "string");
		tipiQuerySpecie.put("phylumdivisione", "string");
		tipiQuerySpecie.put("referenza_tassomica", "int");
		
		tipiQueryUtente.put("id", "string");
		tipiQueryUtente.put("nome", "string");
		tipiQueryUtente.put("cognome", "string");
		tipiQueryUtente.put("email", "string");
		tipiQueryUtente.put("ruolo", "string");
		
		
	}
	
	public Query(SessionProvider provider) {
		sessionProvider = provider;
	}
	
	/*
	 * Single object queries
	 */
	@GraphQLQuery(name="monitoraggioSpecie")
	public MonitoraggioSpecie monitoraggioSpecie(@GraphQLArgument(name="id") long id) {
		return (MonitoraggioSpecie) Accessor.getEremitaManager().getById(MonitoraggioSpecie.class, id);
	}
	
	@GraphQLQuery(name="monitoraggioHabitat")
	public MonitoraggioHabitat monitoraggioHabitat(@GraphQLArgument(name="id") long id) {
		return (MonitoraggioHabitat) Accessor.getEremitaManager().getById(MonitoraggioHabitat.class, id);
	}
	
	@GraphQLQuery(name="intervento")
	public Intervento intervento(@GraphQLArgument(name="id") long id) {
		return (Intervento) Accessor.getEremitaManager().getById(Intervento.class, id);
	}
	
	@GraphQLQuery(name="specie")
	public Specie specie(@GraphQLArgument(name="id")long id) {
		return (Specie) Accessor.getEremitaManager().getById(Specie.class, id);
	}
	
	@GraphQLQuery(name="sitoNatura2000")
	public SitoNatura2000 sitoNatura2000(@GraphQLArgument(name="id")String id) {
		return (SitoNatura2000) Accessor.getEremitaManager().getById(SitoNatura2000.class, id);
	}
	
	@GraphQLQuery(name="condizioniMeteo")
	public CondizioniMeteo condizioniMeteo(@GraphQLArgument(name="id")String id) {
		return (CondizioniMeteo) Accessor.getEremitaManager().getById(CondizioniMeteo.class, id);
	}
	
	@GraphQLQuery(name="config")
	public Config config(@GraphQLArgument(name="id")String id) {
		return (Config) Accessor.getEremitaManager().getById(Config.class, id);
	}
	
	@GraphQLQuery(name="habitatSpecie")
	public HabitatSpecie habitatSpecie(@GraphQLArgument(name="id")String id) {
		return (HabitatSpecie) Accessor.getEremitaManager().getById(HabitatSpecie.class, id);
	}
	
	@GraphQLQuery(name="limpidezza")
	public Limpidezza limpidezza(@GraphQLArgument(name="id")String id) {
		return (Limpidezza) Accessor.getEremitaManager().getById(Limpidezza.class, id);
	}
	
	@GraphQLQuery(name="marcatura")
	public Marcatura marcatura(@GraphQLArgument(name="id")long id) {
		return (Marcatura) Accessor.getEremitaManager().getById(Marcatura.class, id);
	}
	
	@GraphQLQuery(name="permesso")
	public Permesso permesso(@GraphQLArgument(name="id")String id) {
		return (Permesso) Accessor.getEremitaManager().getById(Permesso.class, id);
	}
	
	@GraphQLQuery(name="ruolo")
	public Ruolo ruolo(@GraphQLArgument(name="id")String id) {
		return (Ruolo) Accessor.getEremitaManager().getById(Ruolo.class, id);
	}
	
	@GraphQLQuery(name="segnalazione")
	public Segnalazione segnalazione(@GraphQLArgument(name="id")long id) {
		return (Segnalazione) Accessor.getEremitaManager().getById(Segnalazione.class, id);
	}
	
	@GraphQLQuery(name="metadatiHabitat")
	public MetadatoHabitat metadatiHabitat(@GraphQLArgument(name="id")long id) {
		return (MetadatoHabitat) Accessor.getEremitaManager().getById(MetadatoHabitat.class,id);
	}
	
	@GraphQLQuery(name="segnalazioneAltreSpecie")
	public SegnalazioneAltreSpecie segnalazioneAltreSpecie(@GraphQLArgument(name="id")long id) {
		return (SegnalazioneAltreSpecie) Accessor.getEremitaManager().getById(SegnalazioneAltreSpecie.class, id);
	}
	
	@GraphQLQuery(name="stadioSviluppo")
	public StadioSviluppo stadioSviluppo(@GraphQLArgument(name="id")String id) {
		return (StadioSviluppo) Accessor.getEremitaManager().getById(StadioSviluppo.class, id);
	}
	
	@GraphQLQuery(name="tipologiaMonitoraggio")
	public TipologiaMonitoraggio tipologiaMonitoraggio(@GraphQLArgument(name="id")String id) {
		return (TipologiaMonitoraggio) Accessor.getEremitaManager().getById(TipologiaMonitoraggio.class, id);
	}
	
	@GraphQLQuery(name="tipoMarcatura")
	public TipoMarcatura tipoMarcatura(@GraphQLArgument(name="id")String id) {
		return (TipoMarcatura) Accessor.getEremitaManager().getById(TipoMarcatura.class, id);
	}
	
	@GraphQLQuery(name="tipoReperto")
	public TipoReperto tipoReperto(@GraphQLArgument(name="id")String id) {
		return (TipoReperto) Accessor.getEremitaManager().getById(TipoReperto.class, id);
	}
	
	@GraphQLQuery(name="utente")
	public Utente utente(@GraphQLArgument(name="id")String id) {
		return (Utente) Accessor.getEremitaManager().getById(Utente.class, id);
	}
	
	@GraphQLQuery(name="metadatiHabitatSpecie")
	public List<Metadato> metadatiHabitatSpecie(@GraphQLArgument(name="id")Long id) {
		List<Object> parametri = new ArrayList<Object>();
		parametri.add(id);
		return Accessor.getEremitaManager().getSql(Metadato.class,queryMetadatiHabitatPerSpecie,parametri,null);
	}
	/*
	 * Group queries
	 */
	
	/*
	 * DOCUMENTO
	 */
	
	@GraphQLQuery(name="documento")
	public Documento documento(@GraphQLArgument(name="id") Long id) {

		
		return Accessor.getEremitaManager().getById(Documento.class, id);
	}
	
	@GraphQLQuery(name="documentos")
	public List<Documento> documentos(@GraphQLArgument(name="filtri") Collection<Filter> filtri, @GraphQLArgument(name="pagination") Pagination p, @GraphQLArgument(name="orderBy") OrderBy orderBy) {

		
		List<Object> parametri = new ArrayList<Object>();
		String query = new QueryBuilder("EREMITA_DOCUMENTO", filtri,tipiQueryDocumento,orderBy).makeQuery(parametri);
		
		return Accessor.getEremitaManager().getSql(Documento.class,query,parametri,p);
	}
	
	@GraphQLQuery(name="countDocumentos")
	public long countDocumentos(@GraphQLArgument(name="filtri") Collection<Filter> filtri) {

		
		List<Object> parametri = new ArrayList<Object>();
		String query = new QueryBuilder("EREMITA_DOCUMENTO", filtri,tipiQueryDocumento,null).makeCountQuery(parametri);
		
		return Long.parseLong(Accessor.getEremitaManager().getSqlSingleResult(null,query,parametri).toString());
	}
	
	@GraphQLQuery(name="documentos2")
	public List<Documento> documentos2(@GraphQLArgument(name="filtro")String filtro, @GraphQLArgument(name="pagination") Pagination p, @GraphQLArgument(name="orderBy") OrderBy orderBy) {

		if (filtro==null) filtro="";
		List<Object> parametri = new ArrayList<Object>();
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		
		String q = queryDocumentiSmartFilter;
		String autorizzazioni = ObjectAuthorizerFactory.getQueryCondition(utenteSessione(), new Documento(), "");
		if (autorizzazioni!=null && !"".equals(autorizzazioni)) q+=" and "+autorizzazioni;
		
		if (orderBy!=null) q+= " order by "+orderBy.getCampo()+" "+orderBy.getAsc();
		
		System.out.println(q);
		
		return Accessor.getEremitaManager().getSql(Documento.class,q,parametri,p);
	}
	
	@GraphQLQuery(name="countDocumentos2")
	public long countDocumentos2(@GraphQLArgument(name="filtro") String filtro) {

		if (filtro==null) filtro="";
		List<Object> parametri = new ArrayList<Object>();
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		
		String q = queryCountDocumentiSmartFilter;
		String autorizzazioni = ObjectAuthorizerFactory.getQueryCondition(utenteSessione(), new Documento(), "");
		if (autorizzazioni!=null && !"".equals(autorizzazioni)) q+=" and "+autorizzazioni;
		
		return Long.parseLong(Accessor.getEremitaManager().getSqlSingleResult(null,q,parametri).toString());
	}
	
	/*
	 * MONITORAGGIO SPECIE
	 */
	@GraphQLQuery(name="monitoraggioSpecies")
	public List<MonitoraggioSpecie> monitoraggioSpecies(@GraphQLArgument(name="filtri") Collection<Filter> filtri, @GraphQLArgument(name="pagination") Pagination p, @GraphQLArgument(name="orderBy") OrderBy orderBy) {

		
		List<Object> parametri = new ArrayList<Object>();
		String autorizzazioni = ObjectAuthorizerFactory.getQueryCondition(utenteSessione(), new MonitoraggioSpecie(), "");
		
		
		String query = new QueryBuilder("EREMITA_MONITORAGGIO_SPECIE", filtri,tipiQueryMonitoraggioSpecie,orderBy,autorizzazioni).makeQuery(parametri);
		
		return Accessor.getEremitaManager().getSql(MonitoraggioSpecie.class,query,parametri,p);
	}
	
	@GraphQLQuery(name="interventi")
	public List<Intervento> interventi(@GraphQLArgument(name="filtro")String filtro, @GraphQLArgument(name="pagination") Pagination p, @GraphQLArgument(name="orderBy") OrderBy orderBy) {

		if (filtro==null) filtro="";
		List<Object> parametri = new ArrayList<Object>();
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		
		String q = queryInterventoSmartFilter;
		String autorizzazioni = ObjectAuthorizerFactory.getQueryCondition(utenteSessione(), new Intervento(), "");
		//if (autorizzazioni!=null && !"".equals(autorizzazioni)) q+=" and "+autorizzazioni;
		
		if (orderBy!=null) q+= " order by "+orderBy.getCampo()+" "+orderBy.getAsc();
		else q+=" order by ms.id";
		System.out.println(q);
		
		return Accessor.getEremitaManager().getSql(Intervento.class,q,parametri,p);
	}
	
	@GraphQLQuery(name="countInterventi")
	public long countInterventi(@GraphQLArgument(name="filtro") String filtro) {

		if (filtro==null) filtro="";
		List<Object> parametri = new ArrayList<Object>();
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		
		String q = queryCountInterventoSmartFilter;
		String autorizzazioni = ObjectAuthorizerFactory.getQueryCondition(utenteSessione(), new Intervento(), "");
		//if (autorizzazioni!=null && !"".equals(autorizzazioni)) q+=" and "+autorizzazioni;
		
		return Long.parseLong(Accessor.getEremitaManager().getSqlSingleResult(null,q,parametri).toString());
	}
	
	@GraphQLQuery(name="monitoraggioSpecies2")
	public List<MonitoraggioSpecie> monitoraggioSpecies2(@GraphQLArgument(name="filtro")String filtro, @GraphQLArgument(name="pagination") Pagination p, @GraphQLArgument(name="orderBy") OrderBy orderBy) {

		if (filtro==null) filtro="";
		List<Object> parametri = new ArrayList<Object>();
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		
		String q = queryMonitoraggioSpecieSmartFilter;
		String autorizzazioni = ObjectAuthorizerFactory.getQueryCondition(utenteSessione(), new MonitoraggioSpecie(), "");
		if (autorizzazioni!=null && !"".equals(autorizzazioni)) q+=" and "+autorizzazioni;
		
		if (orderBy!=null) q+= " order by "+orderBy.getCampo()+" "+orderBy.getAsc();
		else q+=" order by ms.id";
		System.out.println(q);
		
		return Accessor.getEremitaManager().getSql(MonitoraggioSpecie.class,q,parametri,p);
	}
	
	@GraphQLQuery(name="countMonitoraggioSpecies")
	public long countMonitoraggioSpecies(@GraphQLArgument(name="filtri") Collection<Filter> filtri) {

		
		List<Object> parametri = new ArrayList<Object>();
		String autorizzazioni = ObjectAuthorizerFactory.getQueryCondition(utenteSessione(), new MonitoraggioSpecie(), "");
		String query = new QueryBuilder("EREMITA_MONITORAGGIO_SPECIE", filtri,tipiQueryMonitoraggioSpecie,null,autorizzazioni).makeCountQuery(parametri);
		
		return Long.parseLong(Accessor.getEremitaManager().getSqlSingleResult(null,query,parametri).toString());
	}
	
	@GraphQLQuery(name="countMonitoraggioSpecies2")
	public long countMonitoraggioSpecies2(@GraphQLArgument(name="filtro") String filtro) {

		if (filtro==null) filtro="";
		List<Object> parametri = new ArrayList<Object>();
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		
		String q = queryCountMonitoraggioSpecieSmartFilter;
		String autorizzazioni = ObjectAuthorizerFactory.getQueryCondition(utenteSessione(), new MonitoraggioSpecie(), "");
		if (autorizzazioni!=null && !"".equals(autorizzazioni)) q+=" and "+autorizzazioni;
		
		return Long.parseLong(Accessor.getEremitaManager().getSqlSingleResult(null,q,parametri).toString());
	}
	
	@GraphQLQuery(name="utentes2")
	public List<Utente> utentes2(@GraphQLArgument(name="filtro")String filtro, @GraphQLArgument(name="pagination") Pagination p, @GraphQLArgument(name="orderBy") OrderBy orderBy) {

		if (filtro==null) filtro="";
		List<Object> parametri = new ArrayList<Object>();
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		
		String q = queryUtenteSmartFilter;
		String autorizzazioni = ObjectAuthorizerFactory.getQueryCondition(utenteSessione(), new Utente(), "");
		if (autorizzazioni!=null && !"".equals(autorizzazioni)) q+=" and "+autorizzazioni;
		
		if (orderBy!=null) q+= " order by "+orderBy.getCampo()+" "+orderBy.getAsc();
		
		return Accessor.getEremitaManager().getSql(Utente.class,q,parametri,p);
	}
	
	@GraphQLQuery(name="countUtentes2")
	public long countUtentes2(@GraphQLArgument(name="filtro") String filtro) {

		if (filtro==null) filtro="";
		List<Object> parametri = new ArrayList<Object>();
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		
		String q = queryCountUtenteSmartFilter;
		String autorizzazioni = ObjectAuthorizerFactory.getQueryCondition(utenteSessione(), new Utente(), "");
		if (autorizzazioni!=null && !"".equals(autorizzazioni)) q+=" and "+autorizzazioni;
		
		return Long.parseLong(Accessor.getEremitaManager().getSqlSingleResult(null,q,parametri).toString());
	}
	
	
	/*
	 * MONITORAGGIO HABITAT
	 */
	@GraphQLQuery(name="monitoraggioHabitat2")
	public List<MonitoraggioHabitat> monitoraggioHabitat2(@GraphQLArgument(name="filtro")String filtro, @GraphQLArgument(name="pagination") Pagination p, @GraphQLArgument(name="orderBy") OrderBy orderBy) {

		if (filtro==null) filtro="";
		List<Object> parametri = new ArrayList<Object>();
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		
		String q = queryMonitoraggioHabitatSmartFilter;
		String autorizzazioni = ObjectAuthorizerFactory.getQueryCondition(utenteSessione(), new MonitoraggioHabitat(), "");
		if (autorizzazioni!=null && !"".equals(autorizzazioni)) q+=" and "+autorizzazioni;
		
		if (orderBy!=null) q+= " order by "+orderBy.getCampo()+" "+orderBy.getAsc();
		else q+=" order by ms.id";
		
		System.out.println(q);
		
		return Accessor.getEremitaManager().getSql(MonitoraggioHabitat.class,q,parametri,p);
	}
	
	@GraphQLQuery(name="countMonitoraggioHabitat2")
	public long countMonitoraggioHabitat2(@GraphQLArgument(name="filtro") String filtro) {

		if (filtro==null) filtro="";
		List<Object> parametri = new ArrayList<Object>();
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		
		String q = queryCountMonitoraggioHabitatSmartFilter;
		String autorizzazioni = ObjectAuthorizerFactory.getQueryCondition(utenteSessione(), new MonitoraggioHabitat(), "");
		if (autorizzazioni!=null && !"".equals(autorizzazioni)) q+=" and "+autorizzazioni;
		
		return Long.parseLong(Accessor.getEremitaManager().getSqlSingleResult(null,q,parametri).toString());
	}
	
	/*
	 * SPECIE
	 */
	
	@GraphQLQuery(name="species")
	public List<Specie> species(@GraphQLArgument(name="filtri") Collection<Filter> filtri, @GraphQLArgument(name="pagination") Pagination p, @GraphQLArgument(name="orderBy") OrderBy orderBy) {

		List<Object> parametri = new ArrayList<Object>();
		String query = new QueryBuilder("N2000_TAXON_TASSONOMIA", filtri,tipiQuerySpecie,orderBy).makeQuery(parametri);
		
		return Accessor.getEremitaManager().getSql(Specie.class,query,parametri,p);

	}
	
	@GraphQLQuery(name="countSpecies")
	public long countSpecies(@GraphQLArgument(name="filtri") Collection<Filter> filtri) {

		
		List<Object> parametri = new ArrayList<Object>();
		String query = new QueryBuilder("N2000_TAXON_TASSONOMIA", filtri,tipiQuerySpecie,null).makeCountQuery(parametri);
		
		return Long.parseLong(Accessor.getEremitaManager().getSqlSingleResult(null,query,parametri).toString());
	}
	
	@GraphQLQuery(name="specieSmartFilter")
	public List<Specie> specieSmartFilter(@GraphQLArgument(name="testo") String filtro) {

		if (filtro==null) filtro="";
		List<Object> parametri = new ArrayList<Object>();
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add(filtro.toUpperCase()+"%");
		
		return Accessor.getEremitaManager().getSql(Specie.class,querySpecieSmartFilter,parametri,null);

	}
	
	@GraphQLQuery(name="specieProgettos")
	public List<SpecieProgettoEremita> specieProgettos() {


		return Accessor.getEremitaManager().getAll(SpecieProgettoEremita.class);

	}
	
	/*
	 * UTENTE
	 */
	
	@GraphQLQuery(name="utentes")
	public List<Utente> utentes(@GraphQLArgument(name="filtri") Collection<Filter> filtri, @GraphQLArgument(name="pagination") Pagination p, @GraphQLArgument(name="orderBy") OrderBy orderBy) {

		List<Object> parametri = new ArrayList<Object>();
		String query = new QueryBuilder("MAIN_UTENTE", filtri,tipiQueryUtente,orderBy).makeQuery(parametri);
		
		return Accessor.getEremitaManager().getSql(Utente.class,query,parametri,p);

	}
	
	@GraphQLQuery(name="countUtentes")
	public long countUtentes(@GraphQLArgument(name="filtri") Collection<Filter> filtri) {

		
		List<Object> parametri = new ArrayList<Object>();
		String query = new QueryBuilder("MAIN_UTENTE", filtri,tipiQueryUtente,null).makeCountQuery(parametri);
		
		return Long.parseLong(Accessor.getEremitaManager().getSqlSingleResult(null,query,parametri).toString());
	}
	
	/*
	 * SITI NATURA 2000
	 */
	@GraphQLQuery(name="sitoNatura2000s")
	public List<SitoNatura2000> sitoNatura2000s(@GraphQLArgument(name="filtri") Collection<Filter> filtri, @GraphQLArgument(name="pagination") Pagination p, @GraphQLArgument(name="orderBy") OrderBy orderBy) {

		List<Object> parametri = new ArrayList<Object>();
		String query = new QueryBuilder("EREMITA_SITI_N2000", filtri,tipiQuerySitiNatura2000,orderBy).makeQuery(parametri);
		
		return Accessor.getEremitaManager().getSql(SitoNatura2000.class,query,parametri,p);

	}
	@GraphQLQuery(name="countSitoNatura2000s")
	public long countSitoNatura2000s(@GraphQLArgument(name="filtri") Collection<Filter> filtri) {

		
		List<Object> parametri = new ArrayList<Object>();
		String query = new QueryBuilder("EREMITA_SITI_N2000", filtri,tipiQuerySitiNatura2000,null).makeCountQuery(parametri);
		
		return Long.parseLong(Accessor.getEremitaManager().getSqlSingleResult(null,query,parametri).toString());
	}
	@GraphQLQuery(name="sitoNatura2000SmartFilter")
	public List<SitoNatura2000> sitoNatura2000SmartFilter(@GraphQLArgument(name="testo") String filtro) {

		if (filtro==null) filtro="";
		List<Object> parametri = new ArrayList<Object>();
		parametri.add(filtro.toUpperCase()+"%");
		parametri.add("%"+filtro.toUpperCase()+"%");
		
		return Accessor.getEremitaManager().getSql(SitoNatura2000.class,queryNatura2000SmartFilter,parametri,null);

	}
	
	/*
	 * Tabelle che contengono valori per i menu a tendina
	 */
	@GraphQLQuery(name="condizioniMeteos")
	public List<CondizioniMeteo> condizioniMeteos() {
		return Accessor.getEremitaManager().getAll(CondizioniMeteo.class);
	}
	@GraphQLQuery(name="habitatSpecies")
	public List<HabitatSpecie> habitatSpecies() {
		return Accessor.getEremitaManager().getAll(HabitatSpecie.class);
	}
	@GraphQLQuery(name="limpidezzas")
	public List<Limpidezza> limpidezzas() {
		return Accessor.getEremitaManager().getAll(Limpidezza.class);
	}
	@GraphQLQuery(name="tipologiaMonitoraggios")
	public List<TipologiaMonitoraggio> tipologiaMonitoraggios() {
		return Accessor.getEremitaManager().getAll(TipologiaMonitoraggio.class);
	}
	@GraphQLQuery(name="ruolos")
	public List<Ruolo> ruolos() {
		return Accessor.getEremitaManager().getAll(Ruolo.class);
	}
	@GraphQLQuery(name="permessos")
	public List<Permesso> permessos() {
		return Accessor.getEremitaManager().getAll(Permesso.class);
	}
	@GraphQLQuery(name="configs")
	public List<Config> configs() {
		return Accessor.getEremitaManager().getAll(Config.class);
	}
	@GraphQLQuery(name="stadioSviluppos")
	public List<StadioSviluppo> stadioSviluppos() {
		return Accessor.getEremitaManager().getAll(StadioSviluppo.class);
	}
	@GraphQLQuery(name="tipoMarcaturas")
	public List<TipoMarcatura> tipoMarcaturas() {
		return Accessor.getEremitaManager().getAll(TipoMarcatura.class);
	}
	@GraphQLQuery(name="tipoRepertos")
	public List<TipoReperto> tipoRepertos() {
		return Accessor.getEremitaManager().getAll(TipoReperto.class);
	}
	
	/*
	 * Servizi di sessione
	 */
	@GraphQLQuery(name="utenteSessione",description="Ottiene l'utente attualmente loggato.")
	public Utente utenteSessione() {
		return Accessor.getUtenteAttuale(sessionProvider.getRequest());
	}
	@GraphQLQuery(name="haPermesso")
	public Boolean haPermesso(@GraphQLArgument(name="permesso") String permesso) {
		return Accessor.haPermesso(utenteSessione(),permesso);
	}
	
	/*
	 * Filtri e introspezione
	 */
	@GraphQLQuery(name="filtriMonitoraggioSpecie")
	public Map<String,String> filtriMonitoraggioSpecie() {
		return tipiQueryMonitoraggioSpecie;
	}
	
	@GraphQLQuery(name="filtriSpecie")
	public Map<String,String> filtriSpecie() {
		return tipiQuerySpecie;
	}
	
	@GraphQLQuery(name="filtriSitoNatura2000")
	public Map<String,String> filtriSitoNatura2000() {
		return tipiQuerySitiNatura2000;
	}
	
	
	/*
	 * Metadati
	 */
	@GraphQLQuery(name="metadatiSupportatiDocumento")
	public List<Metadato> metadatiSupportatiDocumento() {
		return getMetadatiSupportati(Documento.class);
	}
	
	@GraphQLQuery(name="metadatiDocumento")
	public List<ValoreMetadato> metadatiDocumento(@GraphQLArgument(name="documento") Documento m) {
		return getMetadati(m);
	}
	
	@GraphQLMutation(name="versione")
	public String versione(@GraphQLArgument(name="versione") String m) {
			return "0.1";
	}

	
	private List<ValoreMetadato> getMetadati(Identifiable<Long> m) {
		if (m==null) return null;
		
		Class c = EremitaManager.getEntityClass(m);
		if (c==null) return null;
		
		for (Annotation a : c.getAnnotations()) {
			if (a instanceof Metadata) {
				String entity = ((Metadata) a).nomeEntita();
				if (entity==null) return null;
				
				String s = "select * from main_valore_metadato where tipo_entita='"+entity+"' and id_entita="+m.getId();
				return Accessor.getEremitaManager().getSql(ValoreMetadato.class, s); 
			}
		}
		
		return null;
	}
	
	
	private List<Metadato> getMetadatiSupportati(Class c) {

		if (c==null) return null;
		
		for (Annotation a : c.getAnnotations()) {
			if (a instanceof Metadata) {
				String[] prefixes = ((Metadata)a).prefixes();
				if (prefixes == null) return null;
				
				String s = "select * from main_metadato where ";
				for (int k=0; k<prefixes.length; k++) {
					s += "id like '"+prefixes[k]+"%' ";
					if (k<prefixes.length-1) s+= " or ";
				}
				return Accessor.getEremitaManager().getSql(Metadato.class, s); 
			}
		}
		
		return null;
		
	}

}
